// Pom1 Apple 1 Emulator
// Copyright (C) 2000 Verhille Arnaud
// Copyright (C) 2006 John D. Corrado
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include <SDL.h>
#include <stdio.h>
#include "m6502.h"
#include "pia6820.h"
#include "memory.h"
#include "keyboard.h"
#include "screen.h"
#include "options.h"

int handleInput(void)
{
	SDL_Event event;
	char tmp;

	while (SDL_PollEvent(&event))
	{
		if (event.type == SDL_QUIT)
			return 0;

		if (event.type == SDL_KEYDOWN && event.key.keysym.mod & KMOD_CTRL)
		{
			if (event.key.keysym.sym == SDLK_l)
			{
				loadMemory();
				return 1;
			}
			else if (event.key.keysym.sym == SDLK_s)
			{
				saveMemory();
				return 1;
			}
			else if (event.key.keysym.sym == SDLK_q)
				return 0;
			else if (event.key.keysym.sym == SDLK_r)
			{
				resetPia6820();
				resetM6502();
				return 1;
			}
			else if (event.key.keysym.sym == SDLK_h)
			{
				stopM6502();
				resetM6502();
				resetScreen();
				resetPia6820();
				resetMemory();

				SDL_Delay(200);

				startM6502();

				return 1;
			}
			else if (event.key.keysym.sym == SDLK_p)
			{
				changePixelSize();
				return 1;
			}
			else if (event.key.keysym.sym == SDLK_n)
			{
				if (getPixelSize() > 1)
					setScanline(!getScanline());

				return 1;
			}
			else if (event.key.keysym.sym == SDLK_t)
			{
				changeTerminalSpeed();
				return 1;
			}
			else if (event.key.keysym.sym == SDLK_e)
			{
				setRam8k(!getRam8k());
				return 1;
			}
			else if (event.key.keysym.sym == SDLK_w)
			{
				setWriteInRom(!getWriteInRom());
				return 1;
			}
			else if (event.key.keysym.sym == SDLK_v)
			{
				setIrqBrkVector();
				return 1;
			}
			else if (event.key.keysym.sym == SDLK_f)
			{
				setFullScreen(!getFullScreen());
				SDL_SetVideoMode(280 * getPixelSize(), 192 * getPixelSize(), 8, SDL_HWSURFACE | SDL_DOUBLEBUF | (getFullScreen() ? SDL_FULLSCREEN : 0));
				SDL_ShowCursor(!getFullScreen());
				return 1;
			}
		}

		if (getKbdInterrups() && event.type == SDL_KEYDOWN && !(event.key.keysym.unicode & 0xFF80) && event.key.keysym.sym < 0x80)
		{
			tmp = event.key.keysym.unicode & 0x7F;

			if (tmp >= SDLK_a && tmp <= SDLK_z)
				tmp &= 0x5F;
			else if (tmp == SDLK_BACKSPACE)
				tmp = 0x5F;

			if (tmp < 0x60)
			{
				writeKbd((unsigned char)(tmp + 0x80));
				writeKbdCr(0xA7);
			}
		}
	}

	return 1;
}
